/*
	---------------------------------------
	gbdk custom font example (cabbage 2016)
	=======================================
*/

//the font_tables-
const unsigned char font_1bpp[]={
	5,//type - in this example table, we define 1-bpp graphics data and 128-byte encoding table
	/*	quote from the gbdk docs at http://gbdk.sourceforge.net/doc/html/c0509.html -
		The Font type is a single bit that describes the encoding table and the format 
		of the tile data. The encoding table length is specified by the lower two bits: 
		00: 256 byte encoding table. 
		01: 128 byte encoding table. 
		10: No encoding table - the font is 256 tiles long. 
		11 is reserved. 
		The third bit (0x04) is used to determine if the tile data is compressed. Many 
		tiles do not use shades of grey, and so can be represented in 8 bytes instead 
		of 16. If bit 2 is set, then the tiles are assumed to be 8 bytes long and are 
		expanded to 16 bytes at the load stage.	*/
	/*	note- to use 1bpp font (and save some space in rom), you can export the tiles
		from gbtd with the "Format: Gameboy 2 color" set	*/
		
	29,//num tiles
	
	//encoding table-
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,//blah
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,//blah
	0xFF,0x1B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1A,0x00,// !"#
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x00,0x00,0x00,0x00,0x00,0x1C,//0123
	0x00,0x0A,0x08,0x0B,0x00,0x03,0x0C,0x06,0x0D,0x01,0x0E,0x0F,0x10,0x11,0x12,0x00,//@ABC
	0x13,0x09,0x14,0x05,0x15,0x16,0x17,0x18,0x19,0x04,0x02,0x00,0x00,0x00,0x00,0x00,//PQRS
	0x00,0x0A,0x08,0x0B,0x00,0x03,0x0C,0x06,0x0D,0x01,0x0E,0x0F,0x10,0x11,0x12,0x00,//`abc
	0x13,0x09,0x14,0x05,0x15,0x16,0x17,0x18,0x19,0x04,0x02,0x00,0x00,0x00,0x00,0x00,//pqrs
	/*	note- these offset from the start of the font data, not the start of tile data in vram;
		gbdk forces tile#0 to be blank, and loads the font data starting at tile#1...
		hence the trick to set the SPACE character (' ') to [font#]0xff-->[tile#]0x00 ;)	*/	
};
const/*force the following gbtd-exported data into rom ;)*/
#include "fnt1bpp.c"//this is the font graphics data; you can copy and paste the raw data into above if you prefer--it must directly follow the encoding table data!

const unsigned char font_2bpp[]={1,96,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
};const
#include "fnt2bpp.c"

//the program-
#include <gb/gb.h>
#include <gb/font.h>
#include <stdio.h>
font_t fnt1,fnt2;//FONT_HANDLEs
unsigned char i;
void main(){
	
	font_init();//init gbdk font sys
	fnt1=font_load(font_1bpp);//load the custom font(s)
	fnt2=font_load(font_2bpp);
	
	font_set(fnt1);//set the current font
	printf("\n0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ.!? \n");//print some text
	printf("The quick brown fox jumps over the lazy dog...?!\n\n");
	
	font_set(fnt2);//set the current font
	for(i=0;i!=96;i++)putchar(' '+i);//print some text
	printf("\n\n    GBDK  Custom\n    Font Example\n   (cabbage 2016)");
	
}