// see pandocs for more information about DMG palettes

#define d_ms	60	//delay between fade steps, in milliseconds
const unsigned char FADE_LIGHT[]={	//palette data for fading to/from white
	0,
	(1<<6),
	(1<<4)|(2<<6),
	(1<<2)|(2<<4)|(3<<6)
};
const unsigned char FADE_DARK[]={	//palette data for fading to/from black
	(3<<6)|(3<<4)|(3<<2)|3,
	(3<<6)|(3<<4)|(3<<2)|2,
	(3<<6)|(3<<4)|(2<<2)|1,
	(3<<6)|(2<<4)|(1<<2)
};


//these routines fade only the BKG palette (not sprites!)
lightfadein(){
	for(i=0;i<4;i++){
		wait_vbl_done();
		BGP_REG=FADE_LIGHT[i];
		delay(d_ms);
	}
}
lightfadeout(){
	for(i=3;i>=0;i--){
		wait_vbl_done();
		BGP_REG=FADE_LIGHT[i];
		delay(d_ms);
	}
}
darkfadein(){
	for(i=0;i<4;i++){
		wait_vbl_done();
		BGP_REG=FADE_DARK[i];
		delay(d_ms);
	}
}
darkfadeout(){
	for(i=3;i>=0;i--){
		wait_vbl_done();
		BGP_REG=FADE_DARK[i];
		delay(d_ms);
	}
}

