
/*

	gb2.png converted to gb2.h using gameboy tile data generator v1.3.1 at http://www.chrisantonellis.com/gameboy/gbtdg/

	compile using e.g.:
		lcc -o test.gb test.c

*/
	
	
#include <gb/gb.h>

#include "gb2.h" 	//the graphics data

const unsigned char clear_data[]={0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};	//20 tiles, 0xff = a solid white tile
int i,j;
int joy,lastjoy;	//joypad

#include "fade.c"	//fade routines

void main(){
	//clear the background, or else we'll have garbage
	for(j=0;j<18;j++)
		set_bkg_tiles(0,j,20,1,clear_data);
	
	set_bkg_data(0,gb2_tile_count,gb2_tile_data);	//load the tile data
	set_bkg_tiles( (20-gb2_tile_map_width)/2,0,gb2_tile_map_width,gb2_tile_map_height,gb2_map_data);	//display the tile map
	
	BGP_REG=FADE_LIGHT[0];	//start completely faded to white
	
	SHOW_BKG;
	
	lightfadein();//initial fade in
	
	j=0;
	joy=0;
	while(1){
		lastjoy=joy;		//store the previous frame's joypad state
		wait_vbl_done();	//vsync
		joy=joypad();		//poll the joypad
		
		if(joy&&!lastjoy){//a key was newly pressed
			j++;
			if(j==1){
				lightfadeout();
			}else if(j==2){
				lightfadein();
			}else if(j==3){
				darkfadeout();
			}else if(j==4){
				darkfadein();
				j=0;
			}
		}
		// :)
	}
}





