;****************************************************************************************
; freqTable.c - definitions of 'standard' frequencies. Value calculated are rounded to 
;				nearest	1/100th. Freq (Hz) = 111875 / value.
;........................................................................................


;	.dw $0fe4	; A  0  = 27.50 Hz  : 4068 => 27.50 Hz
;	.dw $0f00	; A# 0  = 29.14 Hz  : 3840 => 29.13 Hz
;	.dw $0e28	; B  0  = 30.87 Hz  : 3624 => 30.87 Hz
;
;-----------------------------------------------------------------------------------------
; octave 1
;-----------------------------------------------------------------------------------------

freqTable:
;(octave starts at 'C')

	.dw $0d5d	; C  1  = 32.70 Hz : 3421 => 32.70 Hz
	.dw $0c9d	; C# 1  = 34.65 Hz : 3229 => 34.65 Hz
	.dw $0be7	; D  1  = 36.71 Hz : 3047 => 36.72 Hz
	.dw $0b3d	; D# 1  = 38.89 Hz : 2877 => 38.89 Hz
	.dw $0a9b	; E  1  = 41.20 Hz : 2715 => 41.21 Hz
	.dw $0a03	; F  1  = 43.65 Hz : 2563 => 43.65 Hz
	.dw $0973	; F# 1  = 46.25 Hz : 2419 => 46.25 Hz
	.dw $08eb	; G  1  = 49.00 Hz : 2283 => 49.00 Hz
	.dw $086b	; G# 1  = 51.91 Hz : 2155 => 51.91 Hz - was $086a = 2154 giving 51.94 Hz
	.dw $07f2	; A  1  = 55.00 Hz : 2034 => 55.00 Hz
	.dw $0780	; A# 1  = 58.27 Hz : 1920 => 58.27 Hz
	.dw $0714	; B  1  = 61.74 Hz : 1812 => 61.74 Hz

;-----------------------------------------------------------------------------------------
; octave 2
;-----------------------------------------------------------------------------------------

	.dw $06af	; C  2 :  65.41 Hz : 1710 =>  65.42 Hz
	.dw $064f	; C# 2 :  69.30 Hz : 1615 =>  69.27 Hz-
	.dw $05f4	; D  2 :  73.42 Hz : 1524 =>  73.41 Hz
	.dw $059e	; D# 2 :  77.78 Hz : 1438 =>  77.80 Hz -
	.dw $054e	; E  2 :  82.41 Hz : 1358 =>  83.38 Hz -
	.dw $0502	; F  2 :  87.31 Hz : 1282 =>  87.27 Hz -
	.dw $04b9	; F# 2 :  92.50 Hz : 1209 =>  92.54 Hz -
	.dw $0476	; G  2 :  98.00 Hz : 1142 =>  97.96 Hz -
	.dw $0435	; G# 2 : 103.83 Hz : 1077 => 103.88 Hz
	.dw $03f9	; A  2 : 110.00 Hz : 1017 => 110.00 Hz
	.dw $03c0	; A# 2 : 116.54 Hz :  960 => 116.54 Hz
	.dw $038a	; B  2 : 123.47 Hz :  906 => 123.48 Hz

;-----------------------------------------------------------------------------------------
; octave 3
;-----------------------------------------------------------------------------------------

	.dw $0357	; C  3 : 130.81 Hz :  855 => 130.848 Hz
	.dw $0327	; C# 3 : 138.59 Hz :  807 => 138.631 Hz
	.dw $02fa	; D  3 : 146.83 Hz :  762 => 146.818 Hz
	.dw $02cf	; D# 3 : 155.56 Hz :  719 => 155.598 Hz
	.dw $02a7	; E  3 : 164.81 Hz :  679 => 164.764 Hz
	.dw $0281	; F  3 : 174.61 Hz :  641 => 174.532 Hz
	.dw $025d	; F# 3 : 185.00 Hz :  605 => 184.917 Hz
	.dw $023b	; G  3 : 196.00 Hz :  571 => 195.928 Hz
	.dw $021b	; G# 3 : 207.65 Hz :  539 => 207.560 Hz
	.dw $01fc	; A  3 : 220.00 Hz :  508 => 220.226 Hz
	.dw $01e0	; A# 3 : 233.38 Hz :  480 => 233.073 Hz
	.dw $01c5	; B  3 : 246.94 Hz :  453 => 246.965 Hz

;-----------------------------------------------------------------------------------------
; octave 4
;-----------------------------------------------------------------------------------------
	
	.dw $01ac	; C  4 : 261.63 Hz :  428 => 261.390 Hz
	.dw $0193	; C# 4 : 277.18 Hz :  403 => 277.605 Hz
	.dw $017d	; D  4 : 293.66 Hz :  381 => 293.635 Hz
	.dw $0168	; D# 4 : 311.13 Hz :  360 => 310.764 Hz
	.dw $0153	; E  4 : 329.63 Hz :  339 => 330.015 Hz
	.dw $0140	; F  4 : 349.23 Hz :  320 => 349.609 Hz
	.dw $012e	; F# 4 : 369.99 Hz :  302 => 370.447 Hz
	.dw $011d	; G  4 : 392.00 Hz :  285 => 392.544 Hz
	.dw $010d	; G# 4 : 415.30 Hz :  269 => 415.892 Hz
	.dw $00fe	; A  4 : 440.00 Hz :  254 => 440.453 Hz
	.dw $00f0	; A# 4 : 466.16 Hz :  240 => 466.146 Hz
	.dw $00e3	; B  4 : 493.88 Hz :  227 => 492.841 Hz


;-----------------------------------------------------------------------------------------
; octave 5
;-----------------------------------------------------------------------------------------
	
	.dw $00d6	; C  5 : 523.25 Hz :  214 => 522.780 Hz
	.dw $00ca	; C# 5 : 554.37 Hz :  202 => 553.837 Hz
	.dw $00be	; D  5 : 587.33 Hz :  190 => 588.816 Hz
	.dw $00b4	; D# 5 : 622.25 Hz :  180 => 621.528 Hz
	.dw $00aa	; E  5 : 659.26 Hz :  170 => 658.088 Hz
	.dw $00a0	; F  5 : 698.46 Hz :  160 => 699.219 Hz
	.dw $0097	; F# 5 : 739.99 Hz :  151 => 740.894 Hz
	.dw $008f	; G  5 : 783.99 Hz :  143 => 782.343 Hz
	.dw $0087	; G# 5 : 830.61 Hz :  135 => 828.704 Hz
	.dw $007f	; A  5 : 880.00 Hz :  127 => 880.906 Hz
	.dw $0078	; A# 5 : 932.33 Hz :  120 => 932.292 Hz
	.dw $0071	; B  5 : 987.77 Hz :  113 => 990.044 Hz


;-----------------------------------------------------------------------------------------
; octave 6
;-----------------------------------------------------------------------------------------
	
	.dw $006b	; C  6 : 1046.50 Hz : 107 => 1045.561 Hz
	.dw $0065	; C# 6 : 1108.73 Hz : 101 => 1107.673 Hz
	.dw $005f	; D  6 : 1174.66 Hz :  95 => 1177.632 Hz
	.dw $005a	; D# 6 : 1244.51 Hz :  90 => 1243.056 Hz
	.dw $0055	; E  6 : 1318.51 Hz :  85 => 1316.176 Hz
	.dw $0050	; F  6 : 1396.91 Hz :  80 => 1398.438 Hz
	.dw $004b	; F# 6 : 1479.98 Hz :  75 => 1491.667 Hz
	.dw $0046	; G  6 : 1567.98 Hz :  70 => 1598.214 Hz
	.dw $0043	; G# 6 : 1661.22 Hz :  67 => 1669.776 Hz
	.dw $0040	; A  6 : 1760.00 Hz :  64 => 1748.047 Hz
	.dw $003c	; A# 6 : 1864.66 Hz :  60 => 1864.583 Hz
	.dw $0039	; B  6 : 1975.53 Hz :  57 => 1962.719 Hz


;-----------------------------------------------------------------------------------------
; octave 7
;-----------------------------------------------------------------------------------------
	
	.dw $0035	; C  7 : 2093.00 Hz :  53 => 2110.849 Hz
	.dw $0032	; C# 7 : 2217.46 Hz :  50 => 2237.500 Hz
	.dw $0030	; D  7 : 2439.32 Hz :  48 => 2330.729 Hz
	.dw $002d	; D# 7 : 2489.02 Hz :  45 => 2486.111 Hz
	.dw $002a	; E  7 : 2637.02 Hz :  42 => 2663.690 Hz
	.dw $0028	; F  7 : 2793.83 Hz :  40 => 2796.875 Hz
	.dw $0026	; F# 7 : 2959.96 Hz :  38 => 2944.079 Hz
	.dw $0024	; G  7 : 3135.96 Hz :  36 => 3107.639 Hz
	.dw $0022	; G# 7 : 3322.44 Hz :  34 => 3290.441 Hz
	.dw $0020	; A  7 : 3520.00 Hz :  32 => 3496.094 Hz
	.dw $001e	; A# 7 : 3729.31 Hz :  30 => 3729.167 Hz
	.dw $001c	; B  7 : 3951.07 Hz :  28 => 3995.536 Hz

;-----------------------------------------------------------------------------------------
; octave 8
;-----------------------------------------------------------------------------------------

	.dw $001b	; C  8 : 4186.01 Hz :  27 => 4143.519 Hz
			; C# 8 : 4434.92 Hz : 
			; D  8 : 4698.64 Hz : 
			; D# 8 : 4978.03 Hz : 

